/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.TurnedFaceUpSourceTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.search.SearchLibraryPutOntoBattlefieldTappedRestInHandEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.DisguiseAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.target.common.TargetCardInLibrary;

public final class FlourishingBloomKin
extends CardImpl {
    private static final FilterControlledPermanent filterForests = new FilterControlledPermanent(SubType.FOREST);
    private static final FilterCard filterForestCards = new FilterCard("Forest cards");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public FlourishingBloomKin(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{G}");
        this.subtype.add((Object)SubType.PLANT);
        this.subtype.add((Object)SubType.ELEMENTAL);
        this.power = new MageInt(0);
        this.toughness = new MageInt(0);
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new BoostSourceEffect(xValue, xValue, Duration.WhileOnBattlefield));
        this.addAbility(ability.addHint(hint));
        this.addAbility((Ability)new DisguiseAbility((Card)this, (Cost)new ManaCostsImpl("{4}{G}")));
        this.addAbility((Ability)new TurnedFaceUpSourceTriggeredAbility((Effect)new SearchLibraryPutOntoBattlefieldTappedRestInHandEffect(new TargetCardInLibrary(0, 2, filterForestCards)).setText("search your library for up to two Forest cards and reveal them. Put one of them onto the battlefield tapped and the other into your hand, then shuffle")));
    }

    private FlourishingBloomKin(FlourishingBloomKin card) {
        super((CardImpl)card);
    }

    public FlourishingBloomKin copy() {
        return new FlourishingBloomKin(this);
    }

    static {
        filterForestCards.add((Predicate)SubType.FOREST.getPredicate());
        xValue = new PermanentsOnBattlefieldCount((FilterPermanent)filterForests);
        hint = new ValueHint("Forests you control", xValue);
    }
}

