/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.SoulbondAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FloweringLumberknotEffect
extends RestrictionEffect {
    FloweringLumberknotEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack or block unless it's paired with a creature with soulbond";
    }

    private FloweringLumberknotEffect(FloweringLumberknotEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            Permanent paired;
            if (permanent.getPairedCard() != null && (paired = permanent.getPairedCard().getPermanent(game)) != null) {
                boolean found = false;
                for (Ability ability : paired.getAbilities(game)) {
                    if (!(ability instanceof SoulbondAbility)) continue;
                    found = true;
                    break;
                }
                return !found;
            }
            return true;
        }
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public FloweringLumberknotEffect copy() {
        return new FloweringLumberknotEffect(this);
    }
}

