/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.cards.f.FoeRazerRegentDelayedTriggeredAbility;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FoeRazerRegentTriggeredAbility
extends TriggeredAbilityImpl {
    FoeRazerRegentTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new FoeRazerRegentDelayedTriggeredAbility(), true), false);
    }

    private FoeRazerRegentTriggeredAbility(FoeRazerRegentTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FoeRazerRegentTriggeredAbility copy() {
        return new FoeRazerRegentTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.FIGHTED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent != null && permanent.isControlledBy(this.getControllerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control fights, put two +1/+1 counters on it at the beginning of the next end step.";
    }
}

