/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class FontOfAgoniesTriggeredAbility
extends TriggeredAbilityImpl {
    FontOfAgoniesTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.BLOOD.createInstance()), false);
    }

    private FontOfAgoniesTriggeredAbility(FontOfAgoniesTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FontOfAgoniesTriggeredAbility copy() {
        return new FontOfAgoniesTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType().equals((Object)GameEvent.EventType.LIFE_PAID);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.controllerId) && event.getAmount() > 0) {
            this.getEffects().clear();
            if (event.getAmount() > 0) {
                this.addEffect((Effect)new AddCountersSourceEffect(CounterType.BLOOD.createInstance(event.getAmount())));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever you pay life, put that many blood counters on {this}.";
    }
}

