/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileTargetCost;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.cards.Card;
import mage.cards.f.FoodChainManaBuilder;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FoodChainManaEffect
extends ManaEffect {
    ConditionalManaBuilder manaBuilder = new FoodChainManaBuilder();

    FoodChainManaEffect() {
        this.staticText = "Add X mana of any one color, where X is 1 plus the exiled creature's mana value. Spend this mana only to cast creature spells";
    }

    private FoodChainManaEffect(FoodChainManaEffect effect) {
        super((ManaEffect)effect);
    }

    public FoodChainManaEffect copy() {
        return new FoodChainManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game != null) {
            int cmc = -1;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
                if (!permanent.isCreature(game)) continue;
                cmc = Math.max(cmc, permanent.getManaCost().manaValue());
            }
            if (cmc != -1) {
                netMana.add((Mana)this.manaBuilder.setMana(Mana.BlackMana((int)(cmc + 1)), source, game).build(new Object[0]));
                netMana.add((Mana)this.manaBuilder.setMana(Mana.BlueMana((int)(cmc + 1)), source, game).build(new Object[0]));
                netMana.add((Mana)this.manaBuilder.setMana(Mana.RedMana((int)(cmc + 1)), source, game).build(new Object[0]));
                netMana.add((Mana)this.manaBuilder.setMana(Mana.GreenMana((int)(cmc + 1)), source, game).build(new Object[0]));
                netMana.add((Mana)this.manaBuilder.setMana(Mana.WhiteMana((int)(cmc + 1)), source, game).build(new Object[0]));
            }
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int manaCostExiled = 0;
            for (Cost cost : source.getCosts()) {
                if (!cost.isPaid() || !(cost instanceof ExileTargetCost)) continue;
                for (Card card : ((ExileTargetCost)cost).getPermanents()) {
                    manaCostExiled += card.getManaValue();
                }
            }
            ChoiceColor choice = new ChoiceColor();
            if (!controller.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
                return mana;
            }
            Mana chosen = choice.getMana(manaCostExiled + 1);
            return (Mana)this.manaBuilder.setMana(chosen, source, game).build(new Object[0]);
        }
        return mana;
    }
}

