/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.keyword.AmassEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetOpponentsCreaturePermanent;

class ForayOfOrcsEffect
extends OneShotEffect {
    ForayOfOrcsEffect() {
        super(Outcome.Benefit);
        this.staticText = "amass Orcs 2. When you do, {this} deals X damage to target creature an opponent controls, where X is the amassed Army's power";
    }

    private ForayOfOrcsEffect(ForayOfOrcsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForayOfOrcsEffect copy() {
        return new ForayOfOrcsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = AmassEffect.doAmass((int)2, (SubType)SubType.ORC, (Game)game, (Ability)source);
        if (permanent == null) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect((DynamicValue)new ForayOfOrcsValue(permanent)), false);
        ability.addTarget((Target)new TargetOpponentsCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    private static final class ForayOfOrcsValue
    implements DynamicValue {
        private final Permanent permanent;

        private ForayOfOrcsValue(Permanent permanent) {
            this.permanent = permanent;
        }

        private ForayOfOrcsValue(ForayOfOrcsValue value) {
            this.permanent = value.permanent;
        }

        public int calculate(Game game, Ability sourceAbility, Effect effect) {
            return this.permanent.getPower().getValue();
        }

        public ForayOfOrcsValue copy() {
            return new ForayOfOrcsValue(this);
        }

        public String getMessage() {
            return "the amassed Army's power";
        }

        public String toString() {
            return "X";
        }
    }
}

