/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SpiritToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class ForbiddenOrchardTriggeredAbility
extends TriggeredAbilityImpl {
    ForbiddenOrchardTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenTargetEffect((Token)new SpiritToken()));
        this.addTarget((Target)new TargetOpponent());
        this.setTriggerPhrase("Whenever you tap {this} for mana, ");
    }

    private ForbiddenOrchardTriggeredAbility(ForbiddenOrchardTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent == this.getSourcePermanentOrLKI(game) && this.isControlledBy(event.getPlayerId());
    }

    public ForbiddenOrchardTriggeredAbility copy() {
        return new ForbiddenOrchardTriggeredAbility(this);
    }
}

