/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;

class ForceChokeEffect
extends OneShotEffect {
    ForceChokeEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Counter target spell. Its controller may pay life equal to that spell's mana value to return it to its owner's hand";
    }

    private ForceChokeEffect(ForceChokeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForceChokeEffect copy() {
        return new ForceChokeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        StackObject stackObject = (StackObject)game.getObject(this.getTargetPointer().getFirst(game, source));
        Player objectController = game.getPlayer(stackObject.getControllerId());
        if (player != null) {
            PayLifeCost cost = new PayLifeCost(stackObject.getManaValue());
            if (cost.canPay(source, source, objectController.getId(), game) && objectController.chooseUse(Outcome.LoseLife, "Pay " + stackObject.getManaValue() + " life?", source, game) && cost.pay(source, game, source, objectController.getId(), false, null)) {
                objectController.moveCards((Card)stackObject, Zone.HAND, source, game);
            } else {
                game.getStack().counter(stackObject.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

