/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.f.ForceLiftReturnFromExileEffect;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ForceLiftEffect
extends OneShotEffect {
    private static final String effectText = "Exile target creature. Return that creature to the battlefield under its owner's control at the beginning of the next end step.";

    ForceLiftEffect() {
        super(Outcome.Benefit);
        this.staticText = effectText;
    }

    private ForceLiftEffect(ForceLiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && permanent.moveToExile(source.getSourceId(), "Force Lift", source, game)) {
            Card card;
            ExileZone exile = game.getExile().getExileZone(source.getSourceId());
            if (exile != null && !exile.isEmpty() && (card = game.getCard(permanent.getId())) != null) {
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ForceLiftReturnFromExileEffect(new MageObjectReference((MageObject)card, game))), source);
            }
            return true;
        }
        return false;
    }

    public ForceLiftEffect copy() {
        return new ForceLiftEffect(this);
    }
}

