/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Elemental31TrampleHasteToken;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ForceOfRageEffect
extends OneShotEffect {
    ForceOfRageEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create two 3/1 red Elemental creature tokens with trample and haste. Sacrifice those tokens at the beginning of your next upkeep.";
    }

    private ForceOfRageEffect(ForceOfRageEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForceOfRageEffect copy() {
        return new ForceOfRageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Elemental31TrampleHasteToken token = new Elemental31TrampleHasteToken();
        token.putOntoBattlefield(2, game, source, source.getControllerId());
        ArrayList<Permanent> permanentList = new ArrayList<Permanent>();
        for (UUID permId : token.getLastAddedTokenIds()) {
            permanentList.add(game.getPermanent(permId));
        }
        SacrificeTargetEffect effect = new SacrificeTargetEffect("sacrifice those tokens");
        effect.setTargetPointer((TargetPointer)new FixedTargets(permanentList, game));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility((Effect)effect), source);
        return true;
    }
}

