/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.common.BecomesTargetSourceTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterSpell;
import mage.filter.FilterStackObject;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ForceProjectionEffect
extends OneShotEffect {
    ForceProjectionEffect() {
        super(Outcome.Copy);
        this.staticText = "Create a token that is a copy of target creature you control except that it is an Illusion in addition to its other types and gains \"When this creature becomes the target of a spell, sacrifice it.\"";
    }

    private ForceProjectionEffect(ForceProjectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForceProjectionEffect copy() {
        return new ForceProjectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && permanent != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.withAdditionalSubType(SubType.SPIRIT);
            effect.addAdditionalAbilities(new Ability[]{new BecomesTargetSourceTriggeredAbility((Effect)new SacrificeSourceEffect(), (FilterStackObject)new FilterSpell())});
            return effect.apply(game, source);
        }
        return false;
    }
}

