/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileUntilSourceLeavesEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ForebodingSteamboatExileEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("nontoken, non-Vehicle creatures you control");

    ForebodingSteamboatExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player chooses two nontoken, non-Vehicle creatures they control. Exile them until {this} leaves the battlefield";
    }

    private ForebodingSteamboatExileEffect(ForebodingSteamboatExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForebodingSteamboatExileEffect copy() {
        return new ForebodingSteamboatExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (source.getSourcePermanentIfItStillExists(game) == null) {
            return false;
        }
        HashSet toExile = new HashSet();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            List permanents = game.getBattlefield().getActivePermanents(filter, playerId, source, game);
            if (permanents.size() <= 2) {
                toExile.addAll(permanents);
                continue;
            }
            TargetPermanent target = new TargetPermanent(2, filter);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            toExile.addAll(target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (toExile.isEmpty()) {
            return false;
        }
        return !toExile.isEmpty() && new ExileUntilSourceLeavesEffect().setTargetPointer((TargetPointer)new FixedTargets(toExile, game)).apply(game, source);
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
        filter.add(Predicates.not((Predicate)SubType.VEHICLE.getPredicate()));
    }
}

