/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class ForebodingSteamboatInvestigateEffect
extends OneShotEffect {
    ForebodingSteamboatInvestigateEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a card exiled with it into its owner's graveyard. If you do, investigate";
    }

    private ForebodingSteamboatInvestigateEffect(ForebodingSteamboatInvestigateEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForebodingSteamboatInvestigateEffect copy() {
        return new ForebodingSteamboatInvestigateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getCardExileZoneId((Game)game, (Ability)source));
        if (player == null || exileZone == null) {
            return false;
        }
        switch (exileZone.size()) {
            case 0: {
                return false;
            }
            case 1: {
                card = exileZone.getRandom(game);
                break;
            }
            default: {
                TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD, exileZone.getId());
                target.withChooseHint("to put into its owner's graveyard");
                player.choose(this.outcome, (Target)target, source, game);
                card = game.getCard(target.getFirstTarget());
            }
        }
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.GRAVEYARD, source, game);
        InvestigateEffect.doInvestigate((UUID)player.getId(), (int)1, (Game)game, (Ability)source);
        return true;
    }
}

