/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.keyword.EquipAbility;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class ForgeAnewWatcher
extends Watcher {
    private final Set<UUID> equippedThisTurn = new HashSet<UUID>();

    ForgeAnewWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ACTIVATED_ABILITY) {
            return;
        }
        StackObject object = game.getStack().getStackObject(event.getSourceId());
        if (object != null && object.getStackAbility() instanceof EquipAbility) {
            this.equippedThisTurn.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.equippedThisTurn.clear();
    }

    static boolean checkPlayer(UUID playerId, Game game) {
        ForgeAnewWatcher watcher = (ForgeAnewWatcher)game.getState().getWatcher(ForgeAnewWatcher.class);
        return watcher != null && watcher.equippedThisTurn.contains(playerId);
    }
}

