/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FormlessNurturingEffect
extends OneShotEffect {
    FormlessNurturingEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Manifest the top card of your library, then put a +1/+1 counter on it";
    }

    private FormlessNurturingEffect(FormlessNurturingEffect effect) {
        super((OneShotEffect)effect);
    }

    public FormlessNurturingEffect copy() {
        return new FormlessNurturingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                new ManifestEffect(1).apply(game, source);
                AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance());
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                return effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

