/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class FortifiedBeachheadEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Soldier card from your hand");

    public FortifiedBeachheadEffect() {
        super(Outcome.Tap);
        this.staticText = "you may reveal a Soldier card from your hand. {this} enters tapped unless you revealed a Soldier card this way or you control a Soldier.";
    }

    private FortifiedBeachheadEffect(FortifiedBeachheadEffect effect) {
        super((OneShotEffect)effect);
    }

    public FortifiedBeachheadEffect copy() {
        return new FortifiedBeachheadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent land = game.getPermanentEntering(source.getSourceId());
        if (land == null) {
            return false;
        }
        if (this.revealSoldier(game, source)) {
            return true;
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (!permanent.hasSubtype(SubType.SOLDIER, game)) continue;
            return true;
        }
        land.setTapped(true);
        return true;
    }

    private boolean revealSoldier(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, filter);
        target.withChooseHint("to reveal");
        controller.chooseTarget(Outcome.Benefit, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        return true;
    }

    static {
        filter.add((Predicate)SubType.SOLDIER.getPredicate());
    }
}

