/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.command.Plane;
import mage.game.stack.StackAbility;
import mage.watchers.common.PlanarRollWatcher;

class FracturedPowerstoneEffect
extends OneShotEffect {
    FracturedPowerstoneEffect() {
        super(Outcome.Benefit);
        this.staticText = "Roll the planar die";
    }

    private FracturedPowerstoneEffect(FracturedPowerstoneEffect effect) {
        super((OneShotEffect)effect);
    }

    public FracturedPowerstoneEffect copy() {
        return new FracturedPowerstoneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (CommandObject commandObject : game.getState().getCommand()) {
            if (!(commandObject instanceof Plane)) continue;
            Abilities abilities = commandObject.getAbilities();
            for (Ability ability : abilities) {
                if (!(ability instanceof ActivateIfConditionActivatedAbility)) continue;
                StackAbility stackAbility = new StackAbility(ability, game.getActivePlayerId());
                stackAbility.createCopyOnStack(game, source, source.getControllerId(), true);
                PlanarRollWatcher watcher = (PlanarRollWatcher)game.getState().getWatcher(PlanarRollWatcher.class);
                watcher.removePlanarDieRoll(game.getActivePlayerId());
                return true;
            }
        }
        return false;
    }
}

