/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.Set;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class FranticScapegoatSuspectEffect
extends OneShotEffect {
    FranticScapegoatSuspectEffect() {
        super(Outcome.Benefit);
        this.staticText = "Suspect one of the other creatures";
    }

    private FranticScapegoatSuspectEffect(FranticScapegoatSuspectEffect effect) {
        super((OneShotEffect)effect);
    }

    public FranticScapegoatSuspectEffect copy() {
        return new FranticScapegoatSuspectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Set enteringSet = (Set)this.getValue("franticScapegoatEnteringCreatures");
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && enteringSet != null) {
            Permanent suspect = null;
            if (enteringSet.size() > 1) {
                FilterCreaturePermanent filter = new FilterCreaturePermanent("one of those creatures");
                filter.add((Predicate)new PermanentReferenceInCollectionPredicate((Collection)enteringSet));
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                if (controller.choose(this.outcome, (Target)target, source, game)) {
                    suspect = game.getPermanent(target.getFirstTarget());
                }
            } else {
                for (MageObjectReference s : enteringSet) {
                    suspect = s.getPermanent(game);
                }
            }
            if (suspect != null) {
                suspect.setSuspected(true, game, source);
                Permanent scapegoat = source.getSourcePermanentIfItStillExists(game);
                if (scapegoat != null) {
                    scapegoat.setSuspected(false, game, source);
                }
            }
        }
        return true;
    }
}

