/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class FrayingLineEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    FrayingLineEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may pay {2}. If they do, they put a rope counter on a creature they control. Otherwise, exile {this} and each creature without a rope counter on it, then remove all rope counters from all creatures";
    }

    private FrayingLineEffect(FrayingLineEffect effect) {
        super((OneShotEffect)effect);
    }

    public FrayingLineEffect copy() {
        return new FrayingLineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        GenericManaCost cost = new GenericManaCost(2);
        if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(this.outcome, "Pay {2}?", source, game) && cost.pay(source, game, source, player.getId(), false)) {
            if (!game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source, game, 1)) {
                return true;
            }
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                permanent.addCounters(CounterType.ROPE.createInstance(), player.getId(), source, game);
            }
            return true;
        }
        CardsImpl cards = new CardsImpl((Card)source.getSourcePermanentIfItStillExists(game));
        cards.addAllCards((Collection)game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            permanent.removeAllCounters(CounterType.ROPE.getName(), source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)CounterType.ROPE.getPredicate()));
    }
}

