/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileReturnBattlefieldOwnerNextEndStepSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FreneticSliverEffect
extends OneShotEffect {
    FreneticSliverEffect() {
        super(Outcome.Neutral);
        this.staticText = "if this permanent is on the battlefield, flip a coin. If you win the flip, exile this permanent and return it to the battlefield under its owner's control at the beginning of the next end step. If you lose the flip, sacrifice it";
    }

    private FreneticSliverEffect(FreneticSliverEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent perm = game.getPermanent(source.getSourceId());
        if (player == null || perm == null) {
            return false;
        }
        if (player.flipCoin(source, game, true)) {
            return new ExileReturnBattlefieldOwnerNextEndStepSourceEffect().apply(game, source);
        }
        return perm.sacrifice(source, game);
    }

    public FreneticSliverEffect copy() {
        return new FreneticSliverEffect(this);
    }
}

