/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FrenziedFugueTriggeredAbility
extends TriggeredAbilityImpl {
    public FrenziedFugueTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private FrenziedFugueTriggeredAbility(FrenziedFugueTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FrenziedFugueTriggeredAbility copy() {
        return new FrenziedFugueTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        this.getEffects().clear();
        boolean result = event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD ? event.getTargetId().equals(this.getSourceId()) : event.getPlayerId().equals(this.getControllerId());
        if (result) {
            Permanent enchantment = game.getPermanentOrLKIBattlefield(this.getSourceId());
            if (enchantment != null && enchantment.getAttachedTo() != null) {
                GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfTurn, true);
                effect.setTargetPointer((TargetPointer)new FixedTarget(enchantment.getAttachedTo(), game));
                this.getEffects().add((Object)effect);
                effect = new UntapTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(enchantment.getAttachedTo(), game));
                this.getEffects().add((Object)effect);
                effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(enchantment.getAttachedTo(), game));
                this.getEffects().add((Object)effect);
            } else {
                result = false;
            }
        }
        return result;
    }

    public String getRule() {
        return "When {this} enters or at the beginning of your upkeep, gain control of enchanted permanent until end of turn. Untap that permanent. It gains haste until end of turn.";
    }
}

