/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class FrenzyAbility
extends TriggeredAbilityImpl {
    public FrenzyAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostSourceEffect(1, 0, Duration.EndOfTurn));
    }

    private FrenzyAbility(FrenzyAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FrenzyAbility copy() {
        return new FrenzyAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_BLOCKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(this.getSourceId());
        if (sourcePermanent.isAttacking()) {
            for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                if (!combatGroup.getBlockers().isEmpty() || !combatGroup.getAttackers().contains(this.getSourceId())) continue;
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Frenzy 1. <i>(Whenever this creature attacks and isn't blocked, it gets +1/+0 until end of turn.)</i>";
    }
}

