/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.condition.Condition;
import mage.abilities.keyword.EquipAbility;
import mage.cards.Card;
import mage.constants.SubType;
import mage.filter.FilterSpell;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.command.Commander;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

enum FreyaCrescentCondition implements Condition
{
    instance;

    private static final FilterSpell filter;

    public boolean apply(Game game, Ability source) {
        if (source.isActivated()) {
            return false;
        }
        if (source instanceof EquipAbility) {
            return true;
        }
        if (source instanceof SpellAbility) {
            MageObject object = game.getObject(source);
            if (object instanceof StackObject) {
                return filter.match((StackObject)object, source.getControllerId(), source, game);
            }
            if (game.inCheckPlayableState()) {
                Spell spell = null;
                if (object instanceof Card) {
                    spell = new Spell((Card)object, (SpellAbility)source, source.getControllerId(), game.getState().getZone(source.getSourceId()), game);
                } else if (object instanceof Commander) {
                    spell = new Spell(((Commander)object).getSourceObject(), (SpellAbility)source, source.getControllerId(), game.getState().getZone(source.getSourceId()), game);
                }
                return filter.match(spell, source.getControllerId(), source, game);
            }
        }
        return false;
    }

    static {
        filter = new FilterSpell("Equipment spells");
        filter.add((Predicate)SubType.EQUIPMENT.getPredicate());
    }
}

