/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.ManaUtil;

class FrightfulDelusionEffect
extends OneShotEffect {
    FrightfulDelusionEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell unless its controller pays {1}. That player discards a card.";
    }

    private FrightfulDelusionEffect(FrightfulDelusionEffect effect) {
        super((OneShotEffect)effect);
    }

    public FrightfulDelusionEffect copy() {
        return new FrightfulDelusionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        StackObject spell = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        ManaCost cost = ManaUtil.createManaCost((int)1, (boolean)false);
        if (spell != null && (player = game.getPlayer(spell.getControllerId())) != null) {
            cost.clearPaid();
            game.getPlayer(spell.getControllerId()).discard(1, false, false, source, game);
            if (!cost.pay(source, game, source, spell.getControllerId(), false, null)) {
                return game.getStack().counter(source.getFirstTarget(), source, game);
            }
        }
        return false;
    }
}

