/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.SpecialAction;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.CreateSpecialActionEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.cards.f.FrogkinKidnapperSpecialAction;
import mage.cards.f.FrogkinKidnapperTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class FrogkinKidnapperEffect
extends OneShotEffect {
    FrogkinKidnapperEffect() {
        super(Outcome.Exile);
        this.staticText = "target opponent reveals their hand. Choose a nonland card from it. Ransom that card. <i>(Exile it. Its owner may pay {3} at any time to return it to their hand.)</i>";
    }

    private FrogkinKidnapperEffect(FrogkinKidnapperEffect effect) {
        super((OneShotEffect)effect);
    }

    public FrogkinKidnapperEffect copy() {
        return new FrogkinKidnapperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (opponent == null || controller == null) {
            return false;
        }
        opponent.revealCards(source, opponent.getHand(), game);
        TargetCard target = new TargetCard(1, Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
        CardsImpl toRansom = new CardsImpl();
        if (controller.choose(this.outcome, opponent.getHand(), target, source, game)) {
            toRansom.addAll((Collection)target.getTargets());
            String exileName = "Ransomed (owned by " + opponent.getName() + ")";
            UUID exileId = CardUtil.getExileZoneId((String)("Ransom|" + opponent.getId()), (Game)game);
            for (Card card : toRansom.getCards(game)) {
                card.moveToExile(exileId, exileName, source, game);
                MageObjectReference mor = new MageObjectReference((MageObject)card, game);
                FrogkinKidnapperSpecialAction specialAction = new FrogkinKidnapperSpecialAction(card.getIdName());
                specialAction.getEffects().setTargetPointer((TargetPointer)new FixedTarget(mor));
                new CreateSpecialActionEffect((SpecialAction)specialAction, opponent.getId()).apply(game, source);
                new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new FrogkinKidnapperTriggeredAbility(mor, specialAction.getId()), false).apply(game, source);
            }
        }
        return true;
    }
}

