/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class FromTheAshesEffect
extends OneShotEffect {
    FromTheAshesEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy all nonbasic lands. For each land destroyed this way, its controller may search their library for a basic land card and put it onto the battlefield. Then each player who searched their library this way shuffles";
    }

    private FromTheAshesEffect(FromTheAshesEffect effect) {
        super((OneShotEffect)effect);
    }

    public FromTheAshesEffect copy() {
        return new FromTheAshesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashMap<UUID, Integer> playerAmount = new HashMap<UUID, Integer>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LANDS_NONBASIC, source.getControllerId(), source, game)) {
            UUID controllerId = permanent.getControllerId();
            if (!permanent.destroy(source, game, false)) continue;
            playerAmount.merge(controllerId, 1, Integer::sum);
        }
        game.processAction();
        for (Map.Entry entry : playerAmount.entrySet()) {
            player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            TargetCardInLibrary target = new TargetCardInLibrary(0, ((Integer)entry.getValue()).intValue(), (FilterCard)((Integer)entry.getValue() > 1 ? StaticFilters.FILTER_CARD_BASIC_LANDS : StaticFilters.FILTER_CARD_BASIC_LAND));
            if (player.chooseUse(Outcome.PutLandInPlay, "Search your library for " + target.getDescription() + '?', source, game)) {
                if (!player.searchLibrary(target, source, game) || target.getTargets().isEmpty()) continue;
                player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
                continue;
            }
            entry.setValue(0);
        }
        game.processAction();
        for (Map.Entry entry : playerAmount.entrySet()) {
            player = game.getPlayer((UUID)entry.getKey());
            if (player == null || (Integer)entry.getValue() <= 0) continue;
            player.shuffleLibrary(source, game);
        }
        return true;
    }
}

