/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.MenaceAbility;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class FrontierWarmongerTriggeredAbility
extends TriggeredAbilityImpl {
    FrontierWarmongerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainAbilityTargetEffect((Ability)new MenaceAbility(), Duration.EndOfTurn), false);
    }

    private FrontierWarmongerTriggeredAbility(FrontierWarmongerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FrontierWarmongerTriggeredAbility copy() {
        return new FrontierWarmongerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Set opponents = game.getOpponents(this.getControllerId());
        Predicate<UUID> predicate = uuid -> opponents.contains(game.getCombat().getDefendingPlayerId(uuid, game));
        if (game.getCombat().getAttackers().stream().noneMatch(predicate)) {
            return false;
        }
        List permanents = game.getCombat().getAttackers().stream().filter(predicate).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        this.getEffects().setTargetPointer((TargetPointer)new FixedTargets(permanents, game));
        return true;
    }

    public String getRule() {
        return "Whenever one or more creatures attack one of your opponents or a planeswalker they control, those creatures gain menace until end of turn.";
    }
}

