/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FulgentDistractionEffect
extends OneShotEffect {
    FulgentDistractionEffect() {
        super(Outcome.Tap);
        this.staticText = "Choose two target creatures. Tap those creatures, then unattach all Equipment from them";
    }

    private FulgentDistractionEffect(FulgentDistractionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        for (Permanent permanent : permanents) {
            permanent.tap(source, game);
        }
        for (Permanent permanent : permanents) {
            Set attachments = permanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(attachment -> attachment.hasSubtype(SubType.EQUIPMENT, game)).map(MageItem::getId).collect(Collectors.toSet());
            for (UUID attachmentId : attachments) {
                permanent.removeAttachment(attachmentId, source, game);
            }
        }
        return true;
    }

    public FulgentDistractionEffect copy() {
        return new FulgentDistractionEffect(this);
    }
}

