/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FumigateEffect
extends OneShotEffect {
    FumigateEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures. You gain 1 life for each creature destroyed this way";
    }

    private FumigateEffect(FumigateEffect effect) {
        super((OneShotEffect)effect);
    }

    public FumigateEffect copy() {
        return new FumigateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int destroyedCreature = 0;
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game)) {
                if (!creature.destroy(source, game, false)) continue;
                ++destroyedCreature;
            }
            if (destroyedCreature > 0) {
                game.processAction();
                controller.gainLife(destroyedCreature, game, source);
            }
            return true;
        }
        return false;
    }
}

