/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class CantCounterEffect
extends ContinuousRuleModifyingEffectImpl {
    CantCounterEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Creature spells can't be countered";
    }

    private CantCounterEffect(CantCounterEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CantCounterEffect copy() {
        return new CantCounterEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && spell.isCreature(game);
    }
}

