/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.common.AttackedLastTurnWatcher;

class DontUntapIfAttackedLastTurnSourceEffect
extends ContinuousRuleModifyingEffectImpl {
    DontUntapIfAttackedLastTurnSourceEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, false, true);
        this.staticText = "{this} doesn't untap during your untap step if it attacked during your last turn";
    }

    private DontUntapIfAttackedLastTurnSourceEffect(DontUntapIfAttackedLastTurnSourceEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public DontUntapIfAttackedLastTurnSourceEffect copy() {
        return new DontUntapIfAttackedLastTurnSourceEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObjectReference mor;
        Set attackingCreatures;
        AttackedLastTurnWatcher watcher;
        Permanent permanent;
        return game.getTurnStepType() == PhaseStep.UNTAP && event.getTargetId().equals(source.getSourceId()) && (permanent = game.getPermanent(source.getSourceId())) != null && permanent.isControlledBy(game.getActivePlayerId()) && (watcher = (AttackedLastTurnWatcher)game.getState().getWatcher(AttackedLastTurnWatcher.class)) != null && (attackingCreatures = watcher.getAttackedLastTurnCreatures(permanent.getControllerId())).contains(mor = new MageObjectReference((MageObject)permanent, game));
    }
}

