/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.RampageAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.players.Player;

class GabrielAngelfireGainAbilityEffect
extends GainAbilitySourceEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();

    public GabrielAngelfireGainAbilityEffect() {
        super((Ability)FlyingAbility.getInstance(), Duration.UntilYourNextUpkeepStep);
        this.staticText = "choose flying, first strike, trample, or rampage 3. {this} gains that ability until your next upkeep";
    }

    private GabrielAngelfireGainAbilityEffect(GabrielAngelfireGainAbilityEffect effect) {
        super((GainAbilitySourceEffect)effect);
        this.ability.newId();
    }

    public GabrielAngelfireGainAbilityEffect copy() {
        return new GabrielAngelfireGainAbilityEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setMessage("Choose one");
            choice.setChoices(choices);
            if (controller.choose(this.outcome, (Choice)choice, game)) {
                switch (choice.getChoice()) {
                    case "First strike": {
                        this.ability = FirstStrikeAbility.getInstance();
                        break;
                    }
                    case "Trample": {
                        this.ability = TrampleAbility.getInstance();
                        break;
                    }
                    case "Rampage 3": {
                        this.ability = new RampageAbility(3);
                        break;
                    }
                    default: {
                        this.ability = FlyingAbility.getInstance();
                        break;
                    }
                }
            } else {
                this.discard();
            }
        }
    }

    static {
        choices.add("Flying");
        choices.add("First strike");
        choices.add("Trample");
        choices.add("Rampage 3");
    }
}

