/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.SubTypeAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class GaeasBalanceTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterLandCard("a land card of each basic land type");
    private static final SubTypeAssignment subTypeAssigner;

    GaeasBalanceTarget() {
        super(0, 5, filter);
    }

    private GaeasBalanceTarget(GaeasBalanceTarget target) {
        super((TargetCardInLibrary)target);
    }

    public GaeasBalanceTarget copy() {
        return new GaeasBalanceTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return subTypeAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.PLAINS.getPredicate(), SubType.ISLAND.getPredicate(), SubType.SWAMP.getPredicate(), SubType.MOUNTAIN.getPredicate(), SubType.FOREST.getPredicate()}));
        subTypeAssigner = new SubTypeAssignment(new SubType[]{SubType.PLAINS, SubType.ISLAND, SubType.SWAMP, SubType.MOUNTAIN, SubType.FOREST});
    }
}

