/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.g.GaleaKindlerOfHopeEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class GaleaKindlerOfHopeTriggeredAbility
extends TriggeredAbilityImpl {
    public GaleaKindlerOfHopeTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.setRuleVisible(false);
    }

    private GaleaKindlerOfHopeTriggeredAbility(GaleaKindlerOfHopeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId()) || event.getZone() != Zone.LIBRARY || !event.getApprovingObject().getApprovingMageObjectReference().refersTo(this.getSourceObject(game), game)) {
            return false;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null || !spell.hasSubtype(SubType.EQUIPMENT, game)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new GaleaKindlerOfHopeEffect(spell, game));
        return true;
    }

    public GaleaKindlerOfHopeTriggeredAbility copy() {
        return new GaleaKindlerOfHopeTriggeredAbility(this);
    }

    public String getRule() {
        return "When you cast an Equipment spell this way, it gains \"When this Equipment enters the battlefield, attach it to target creature you control.\"";
    }
}

