/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class GallifreyStandsReturnEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    GallifreyStandsReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return all Doctor cards from your graveyard to your hand";
    }

    private GallifreyStandsReturnEffect(GallifreyStandsReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public GallifreyStandsReturnEffect copy() {
        return new GallifreyStandsReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getGraveyard().getCards(filter, game));
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }

    static {
        filter.add((Predicate)SubType.DOCTOR.getPredicate());
    }
}

