/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GalvanicDischargeEffect
extends OneShotEffect {
    GalvanicDischargeEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose target creature or planeswalker. You get {E}{E}{E}, then you may pay any amount of {E}. {this} deals that much damage to that permanent";
    }

    private GalvanicDischargeEffect(GalvanicDischargeEffect effect) {
        super((OneShotEffect)effect);
    }

    public GalvanicDischargeEffect copy() {
        return new GalvanicDischargeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        new GetEnergyCountersControllerEffect(3).apply(game, source);
        int numberToPay = controller.getAmount(0, controller.getCountersCount(CounterType.ENERGY), "How many {E} do you like to pay?", source, game);
        if (numberToPay <= 0) {
            return true;
        }
        PayEnergyCost cost = new PayEnergyCost(numberToPay);
        if (cost.pay(source, game, source, source.getControllerId(), true) && (targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            targetCreature.damage(numberToPay, source.getSourceId(), source, game, false, true);
        }
        return true;
    }
}

