/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.g.GalvanicRelayMayPlayEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class GalvanicRelayEffect
extends OneShotEffect {
    GalvanicRelayEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top card of your library. During your next turn, you may play that card";
    }

    private GalvanicRelayEffect(GalvanicRelayEffect effect) {
        super((OneShotEffect)effect);
    }

    public GalvanicRelayEffect copy() {
        return new GalvanicRelayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card topCard;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (topCard = controller.getLibrary().getFromTop(game)) != null) {
            Card sourceCard = game.getCard(source.getSourceId());
            controller.moveCardsToExile(topCard, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), sourceCard != null ? sourceCard.getIdName() : "");
            GalvanicRelayMayPlayEffect effect = new GalvanicRelayMayPlayEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(topCard.getId()));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

