/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.stack.Spell;
import mage.players.Player;

class GandalfOfTheSecretFireEffect
extends ReplacementEffectImpl {
    private final MageObjectReference morSpell;
    private final MageObjectReference morCard;

    GandalfOfTheSecretFireEffect(Spell spell, Game game) {
        super(Duration.OneUse, Outcome.Benefit);
        this.morSpell = new MageObjectReference((MageObject)spell.getCard(), game);
        this.morCard = new MageObjectReference((MageObject)spell.getMainCard(), game);
    }

    private GandalfOfTheSecretFireEffect(GandalfOfTheSecretFireEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.morSpell = effect.morSpell;
        this.morCard = effect.morCard;
    }

    public GandalfOfTheSecretFireEffect copy() {
        return new GandalfOfTheSecretFireEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell sourceSpell = this.morSpell.getSpell(game);
        if (controller == null || sourceSpell == null || sourceSpell.isCopy()) {
            return false;
        }
        controller.moveCards((Card)sourceSpell, Zone.EXILED, source, game);
        SuspendAbility.addTimeCountersAndSuspend((Card)sourceSpell.getMainCard(), (int)3, (Ability)source, (Game)game);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return Zone.STACK.equals((Object)zEvent.getFromZone()) && Zone.GRAVEYARD.equals((Object)zEvent.getToZone()) && this.morSpell.refersTo(event.getSourceId(), game) && this.morCard.refersTo(event.getTargetId(), game);
    }
}

