/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.g.GandalfOfTheSecretFireEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class GandalfOfTheSecretFireTriggeredAbility
extends TriggeredAbilityImpl {
    GandalfOfTheSecretFireTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private GandalfOfTheSecretFireTriggeredAbility(GandalfOfTheSecretFireTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GandalfOfTheSecretFireTriggeredAbility copy() {
        return new GandalfOfTheSecretFireTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId()) || this.getControllerId().equals(game.getActivePlayerId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game) || !Zone.HAND.equals((Object)spell.getFromZone())) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new GandalfOfTheSecretFireEffect(spell, game));
        return true;
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell from your hand during an opponent's turn, exile that card with three time counters on it instead of putting it into your graveyard as it resolves. Then if the exiled card doesn't have suspend, it gains suspend.";
    }
}

