/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GargantuanGorillaFightEffect
extends OneShotEffect {
    GargantuanGorillaFightEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage equal to its power to another target creature. That creature deals damage equal to its power to {this}";
    }

    private GargantuanGorillaFightEffect(GargantuanGorillaFightEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null) {
            Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
            Permanent creature1 = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (creature1 != null && sourcePermanent != null && creature1.isCreature(game) && sourcePermanent.isCreature(game)) {
                sourcePermanent.damage(creature1.getPower().getValue(), creature1.getId(), source, game, false, true);
                creature1.damage(sourcePermanent.getPower().getValue(), sourcePermanent.getId(), source, game, false, true);
                return true;
            }
            if (!game.isSimulation()) {
                game.informPlayers(sourceObject.getLogName() + ": Fighting effect has been fizzled.");
            }
        }
        return false;
    }

    public GargantuanGorillaFightEffect copy() {
        return new GargantuanGorillaFightEffect(this);
    }
}

