/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class GarnetPrincessOfAlexandriaEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.SAGA, "Sagas you control");

    GarnetPrincessOfAlexandriaEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may remove a lore counter from each of any number of Sagas you control. Put a +1/+1 counter on {this} for each lore counter removed this way";
    }

    private GarnetPrincessOfAlexandriaEffect(GarnetPrincessOfAlexandriaEffect effect) {
        super((OneShotEffect)effect);
    }

    public GarnetPrincessOfAlexandriaEffect copy() {
        return new GarnetPrincessOfAlexandriaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        target.withChooseHint("to remove lore counters from");
        player.choose(this.outcome, (Target)target, source, game);
        int count = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).mapToInt(permanent -> permanent.removeCounters(CounterType.LORE.createInstance(), source, game)).sum();
        if (count < 1) {
            return false;
        }
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).map(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(count), source, game));
        return true;
    }

    static {
        filter.add((Predicate)CounterType.LORE.getPredicate());
    }
}

