/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.AttachableToRestrictedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class GateSmasher
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature with toughness 4 or greater");

    public GateSmasher(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{3}");
        this.subtype.add((Object)SubType.EQUIPMENT);
        this.addAbility((Ability)new AttachableToRestrictedAbility((Target)new TargetPermanent(filter)));
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new BoostEquippedEffect(3, 0));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)TrampleAbility.getInstance(), AttachmentType.EQUIPMENT).setText("and has trample"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new EquipAbility(3, false));
    }

    private GateSmasher(GateSmasher card) {
        super((CardImpl)card);
    }

    public GateSmasher copy() {
        return new GateSmasher(this);
    }

    static {
        filter.add((Predicate)new ToughnessPredicate(ComparisonType.MORE_THAN, 3));
    }
}

