/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;

class GateToTheAfterlifeEffect
extends OneShotEffect {
    private static String cardName = "God-Pharaoh's Gift";

    public GateToTheAfterlifeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your graveyard, hand, and/or library for a card named " + cardName + " and put it onto the battlefield. If you search your library this way, shuffle";
    }

    private GateToTheAfterlifeEffect(GateToTheAfterlifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public GateToTheAfterlifeEffect copy() {
        return new GateToTheAfterlifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInYourGraveyard target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterCard filter = new FilterCard("card named " + cardName);
        filter.add((Predicate)new NamePredicate(cardName));
        Card card = null;
        if (controller.chooseUse(Outcome.Benefit, "Search your graveyard for " + cardName + "?", source, game)) {
            target = new TargetCardInYourGraveyard(1, 1, filter, true);
            if (controller.choose(this.outcome, (Cards)controller.getGraveyard(), (TargetCard)target, source, game)) {
                card = game.getCard(target.getFirstTarget());
            }
        }
        if (card == null && controller.chooseUse(Outcome.Benefit, "Search your hand for " + cardName + "?", source, game)) {
            target = new TargetCardInHand(0, 1, filter);
            if (controller.choose(Outcome.PutCardInPlay, controller.getHand(), (TargetCard)target, source, game)) {
                card = game.getCard(target.getFirstTarget());
            }
        }
        boolean librarySearched = false;
        if (card == null && controller.chooseUse(Outcome.Benefit, "Search your library for " + cardName + "?", source, game)) {
            librarySearched = true;
            TargetCardInLibrary target2 = new TargetCardInLibrary(filter);
            if (controller.searchLibrary(target2, source, game)) {
                card = game.getCard(target2.getFirstTarget());
            }
            controller.shuffleLibrary(source, game);
        }
        if (card != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        if (librarySearched) {
            controller.shuffleLibrary(source, game);
        }
        return true;
    }
}

