/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GatewatchBeaconMoveCounterEffect
extends OneShotEffect {
    GatewatchBeaconMoveCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may move a loyalty counter from {this} onto that planeswalker";
    }

    private GatewatchBeaconMoveCounterEffect(GatewatchBeaconMoveCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (sourcePermanent == null || controller == null) {
            return false;
        }
        Object enteringObject = this.getValue("permanentEnteringBattlefield");
        if (!(enteringObject instanceof Permanent)) {
            return false;
        }
        int numberOfCounters = sourcePermanent.getCounters(game).getCount(CounterType.LOYALTY);
        if (numberOfCounters == 0) {
            return false;
        }
        Permanent enteringPlaneswalker = (Permanent)enteringObject;
        sourcePermanent.removeCounters(CounterType.LOYALTY.getName(), 1, source, game);
        if (!game.isSimulation()) {
            enteringPlaneswalker.addCounters(CounterType.LOYALTY.createInstance(), source, game);
        }
        return true;
    }

    public GatewatchBeaconMoveCounterEffect copy() {
        return new GatewatchBeaconMoveCounterEffect(this);
    }
}

