/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.Mana;
import mage.ObjectColor;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.TriggeredManaAbility;
import mage.cards.g.GauntletOfPowerManaEffect2;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GauntletOfPowerTapForManaAllTriggeredAbility
extends TriggeredManaAbility {
    GauntletOfPowerTapForManaAllTriggeredAbility() {
        super(Zone.BATTLEFIELD, (ManaEffect)new GauntletOfPowerManaEffect2(), false);
    }

    private GauntletOfPowerTapForManaAllTriggeredAbility(GauntletOfPowerTapForManaAllTriggeredAbility ability) {
        super((TriggeredManaAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        TappedForManaEvent mEvent = (TappedForManaEvent)event;
        Permanent permanent = mEvent.getPermanent();
        if (permanent == null || !permanent.isLand(game) || !permanent.isBasic(game)) {
            return false;
        }
        ObjectColor color = (ObjectColor)game.getState().getValue(this.getSourceId() + "_color");
        if (color == null) {
            return false;
        }
        Mana mana = mEvent.getMana();
        if (!(color.isBlack() && mana.getBlack() >= 1 || color.isBlue() && mana.getBlue() >= 1 || color.isGreen() && mana.getGreen() >= 1 || color.isWhite() && mana.getWhite() >= 1 || color.isRed() && mana.getRed() >= 1)) {
            return false;
        }
        this.getEffects().setValue("mana", (Object)mEvent.getMana());
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        return true;
    }

    public GauntletOfPowerTapForManaAllTriggeredAbility copy() {
        return new GauntletOfPowerTapForManaAllTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a basic land is tapped for mana of the chosen color, its controller adds an additional one mana of that color.";
    }
}

