/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class GazeOfGraniteEffect
extends OneShotEffect {
    GazeOfGraniteEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy each nonland permanent with mana value X or less";
    }

    private GazeOfGraniteEffect(GazeOfGraniteEffect effect) {
        super((OneShotEffect)effect);
    }

    public GazeOfGraniteEffect copy() {
        return new GazeOfGraniteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (permanent.isLand(game) || permanent.getManaValue() > (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

