/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObjectReference;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.AssignNoCombatDamageTargetEffect;
import mage.cards.g.GazeOfPainEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GazeOfPainDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    GazeOfPainDelayedTriggeredAbility() {
        super(null, Duration.EndOfTurn, false, true);
        this.addTarget((Target)new TargetCreaturePermanent());
    }

    private GazeOfPainDelayedTriggeredAbility(GazeOfPainDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNBLOCKED_ATTACKER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(game.getControllerId(event.getTargetId()))) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new GazeOfPainEffect(new MageObjectReference(event.getTargetId(), game)));
        this.addEffect((Effect)new AssignNoCombatDamageTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game)));
        return true;
    }

    public GazeOfPainDelayedTriggeredAbility copy() {
        return new GazeOfPainDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "Until end of turn, whenever a creature you control attacks and isn't blocked, you may choose to have it deal damage equal to its power to a target creature. If you do, it assigns no combat damage this turn.";
    }
}

