/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GazeOfPainEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    GazeOfPainEffect(MageObjectReference mor) {
        super(Outcome.Benefit);
        this.mor = mor;
    }

    private GazeOfPainEffect(GazeOfPainEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public GazeOfPainEffect copy() {
        return new GazeOfPainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent creature = this.mor.getPermanent(game);
        Permanent targeted = game.getPermanent(source.getFirstTarget());
        return player != null && creature != null && targeted != null && targeted.damage(creature.getPower().getValue(), creature.getId(), source, game) > 0;
    }
}

