/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.GeminiEngineTwinToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GeminiEngineCreateTokenEffect
extends OneShotEffect {
    GeminiEngineCreateTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a colorless Construct artifact creature token named Twin that's attacking. Its power is equal to {this}'s power and its toughness is equal to {this}'s toughness. Sacrifice the token at end of combat.";
    }

    private GeminiEngineCreateTokenEffect(GeminiEngineCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public GeminiEngineCreateTokenEffect copy() {
        return new GeminiEngineCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        GeminiEngineTwinToken token = permanent != null ? new GeminiEngineTwinToken(permanent.getPower().getValue(), permanent.getToughness().getValue()) : new GeminiEngineTwinToken(0, 0);
        token.putOntoBattlefield(1, game, source, source.getControllerId(), false, true);
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent tokenPerm = game.getPermanent(tokenId);
            if (tokenPerm == null) continue;
            SacrificeTargetEffect effect = new SacrificeTargetEffect("sacrifice " + tokenPerm.getLogName(), player.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(tokenPerm, game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheEndOfCombatDelayedTriggeredAbility((Effect)effect), source);
        }
        return true;
    }
}

