/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.OpeningHandAction;
import mage.abilities.StaticAbility;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.g.GemstoneCavernsEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GemstoneCavernsAbility
extends StaticAbility
implements OpeningHandAction {
    public GemstoneCavernsAbility() {
        super(Zone.HAND, (Effect)new GemstoneCavernsEffect());
    }

    private GemstoneCavernsAbility(GemstoneCavernsAbility ability) {
        super((StaticAbility)ability);
    }

    public GemstoneCavernsAbility copy() {
        return new GemstoneCavernsAbility(this);
    }

    public String getRule() {
        return "If this card is in your opening hand and you're not the starting player, you may begin the game with {this} on the battlefield with a luck counter on it. If you do, exile a card from your hand.";
    }

    public boolean askUseOpeningHandAction(Card card, Player player, Game game) {
        return player.chooseUse(Outcome.PutCardInPlay, "Put " + card.getIdName() + " onto the battlefield?", (Ability)this, game);
    }

    public boolean isOpeningHandActionAllowed(Card card, Player player, Game game) {
        return !player.getId().equals(game.getStartingPlayerId());
    }

    public void doOpeningHandAction(Card card, Player player, Game game) {
        this.resolve(game);
    }
}

